#!/bin/sh
#============================================================+
# Dateiname   : DB_delete.sh
# Letztes Update : 2012-02-07
#
# Beschreibung : Datenbankeinträge älter als 3 Monate löschen
#
# Autor: Michael Krahn, Andreas Reichert
#
# Lizenz; GNU General Public License (GPL) V3
# www.imrazor.de
#============================================================+

#Zugangsdaten fuer die Datenbank
TABLE_NAME="radius"
USER="root"
IP_ADDR="localhost"
PASSWORD="datenbankpasswort" #Anpassen!!


#Auszufuehrender Code
datum=$(date -d "3 month ago" +%Y-%m-%d)											#Ermittlung des Datums vor 3 Monaten

#mysql-Befehle
query_max_firma_id="select max(firma_id) from firma where datum <= '$datum'"
query_delete_firma="delete from firma where datum <= '$datum'"
#query_delete_radcheck="delete from radcheck where id <= ($max_firma_id * 2)"				# wird erst weiter unten ausgefuert, da Variable noch nicht belegt ist
query_max_id="select max(firma_id) from firma"
#query_mod_id_firma="update firma set firma_id = firma_id - $korr_wert"
#query_mod_id="update radcheck set id = id - $korr_wert2"
query_min_id="select min(firma_id) from firma"

#Befehlausfuerhung
array_max_firma_id=($(mysql -u $USER -p$PASSWORD $TABLE_NAME -e "$query_max_firma_id"))
max_firma_id=${array_max_firma_id[1]}									# Ermittlung der groessten id in firma, die aelter als 3 Monate ist
array_max_id=($(mysql -u$USER -p$PASSWORD $TABLE_NAME -e "$query_max_id"))
max_id=${array_max_id[1]}										# Ermittlung der hoechsten id in firma
array_min_id=($(mysql -u$USER -p$PASSWORD $TABLE_NAME -e "$query_min_id"))
min_id=${array_min_id[1]}

query_delete_radcheck="delete from radcheck where id <= ($max_firma_id * 2)"				# Eingeschobener query

if [ "$max_id" != "NULL" ]
then
mysql -u $USER -p$PASSWORD $TABLE_NAME -e "$query_delete_firma"						# 3 Monate alte Eintraege aus firma loeschen
mysql -u $USER -p$PASSWORD $TABLE_NAME -e "$query_delete_radcheck"					# 3 Monate alte Eintraege aus radcheck loeschen

#Korrektur der Nummerierung nur dann, wenn keine korrekte Nummerierung vorliegt
korr_wert=$max_firma_id
korr_wert2=$(expr $max_firma_id \* 2)

# Eingeschobene queries
query_mod_id_firma="update firma set firma_id = firma_id -$korr_wert, id = id - $korr_wert2"
query_mod_id="update radcheck set id = id - $korr_wert2"

new_count1=$(expr $max_id - $max_firma_id + 1 )
new_count2=$(expr $new_count1 \* 2 - 1 )

mysql -u $USER -p$PASSWORD $TABLE_NAME -e "$query_mod_id_firma"						# Korrektur der Nummerierung in firma
mysql -u $USER -p$PASSWORD $TABLE_NAME -e "$query_mod_id"						# Korrektur der Nummerierung in radcheck
mysql -u $USER -p$PASSWORD $TABLE_NAME -e "alter table radcheck auto_increment = $new_count2"
mysql -u $USER -p$PASSWORD $TABLE_NAME -e "alter table firma auto_increment = $new_count1"

# Loeschung der alten PDF-Files
find /var/www/logins/ *.pdf -mtime +90 -exec rm -f {} \;
fi

